-- pkwliste.com
-- Demo Datenbank
-- https://www.pkwliste.com/

SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
START TRANSACTION;
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `fahrzeuge`
--

DROP TABLE IF EXISTS `fahrzeuge`;
CREATE TABLE `fahrzeuge` (
  `id` int(11) NOT NULL,
  `hersteller_id` int(11) DEFAULT NULL,
  `hersteller_name` varchar(128) DEFAULT NULL,
  `modell_id` int(11) DEFAULT NULL,
  `modell_name` varchar(128) DEFAULT NULL,
  `fahrzeug_id` int(11) DEFAULT NULL,
  `fahrzeug_name` varchar(128) DEFAULT NULL,
  `fahrzeug_typ` varchar(128) DEFAULT NULL,
  `fahrzeug_form` varchar(128) DEFAULT NULL,
  `fahrzeug_eg_nummer` varchar(128) DEFAULT NULL,
  `fahrzeug_antriebsachse` varchar(128) DEFAULT NULL,
  `fahrzeug_achslast_va` varchar(16) DEFAULT NULL,
  `fahrzeug_achslast_ha` varchar(16) DEFAULT NULL,
  `fahrzeug_zul_gesamtgewicht` varchar(16) DEFAULT NULL,
  `fahrzeug_laenge` varchar(16) DEFAULT NULL,
  `fahrzeug_breite` varchar(16) DEFAULT NULL,
  `fahrzeug_hoehe` varchar(16) DEFAULT NULL,
  `fahrzeug_stuetzlast` varchar(16) DEFAULT NULL,
  `fahrzeug_anhaengelast_gebremst` varchar(16) DEFAULT NULL,
  `fahrzeug_anhaengelast_ungebremst` varchar(16) DEFAULT NULL,
  `fahrzeug_treibstoff` varchar(128) DEFAULT NULL,
  `fahrzeug_motor` varchar(128) DEFAULT NULL,
  `fahrzeug_motorcode` varchar(128) DEFAULT NULL,
  `fahrzeug_motor_oelmenge` varchar(16) DEFAULT NULL,
  `fahrzeug_schaltgetriebecode` varchar(128) DEFAULT NULL,
  `fahrzeug_schaltgetriebe_menge` varchar(16) DEFAULT NULL,
  `fahrzeug_automatikgetriebecode` varchar(128) DEFAULT NULL,
  `fahrzeug_automatikgetriebe_menge` varchar(16) DEFAULT NULL,
  `fahrzeug_bremsfluessigkeits_menge` varchar(16) DEFAULT NULL,
  `fahrzeug_kuehlfluessigkeits_menge` varchar(16) DEFAULT NULL,
  `fahrzeug_ps` varchar(16) DEFAULT NULL,
  `fahrzeug_kw` varchar(16) DEFAULT NULL,
  `fahrzeug_leistung_bei_umdrehungen` varchar(16) DEFAULT NULL,
  `fahrzeug_hubraum` varchar(16) DEFAULT NULL,
  `fahrzeug_co2_emissions_wert` varchar(16) DEFAULT NULL,
  `fahrzeug_leergewicht` varchar(16) DEFAULT NULL,
  `fahrzeug_max_kmh` varchar(16) DEFAULT NULL,
  `fahrzeug_sitzanzahl` varchar(16) DEFAULT NULL,
  `fahrzeug_tueranzahl` varchar(16) DEFAULT NULL,
  `fahrzeug_prod_monat_von` varchar(16) DEFAULT NULL,
  `fahrzeug_prod_monat_bis` varchar(16) DEFAULT NULL,
  `fahrzeug_prod_jahr_von` varchar(16) DEFAULT NULL,
  `fahrzeug_prod_jahr_bis` varchar(16) DEFAULT NULL,
  `fahrzeug_hsn` varchar(16) DEFAULT NULL,
  `fahrzeug_tsn` varchar(16) DEFAULT NULL,
  `fahrzeug_vsn` varchar(16) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

--
-- Daten für Tabelle `fahrzeuge`
--

INSERT INTO `fahrzeuge` (`id`, `hersteller_id`, `hersteller_name`, `modell_id`, `modell_name`, `fahrzeug_id`, `fahrzeug_name`, `fahrzeug_typ`, `fahrzeug_form`, `fahrzeug_eg_nummer`, `fahrzeug_antriebsachse`, `fahrzeug_achslast_va`, `fahrzeug_achslast_ha`, `fahrzeug_zul_gesamtgewicht`, `fahrzeug_laenge`, `fahrzeug_breite`, `fahrzeug_hoehe`, `fahrzeug_stuetzlast`, `fahrzeug_anhaengelast_gebremst`, `fahrzeug_anhaengelast_ungebremst`, `fahrzeug_treibstoff`, `fahrzeug_motor`, `fahrzeug_motorcode`, `fahrzeug_motor_oelmenge`, `fahrzeug_schaltgetriebecode`, `fahrzeug_schaltgetriebe_menge`, `fahrzeug_automatikgetriebecode`, `fahrzeug_automatikgetriebe_menge`, `fahrzeug_bremsfluessigkeits_menge`, `fahrzeug_kuehlfluessigkeits_menge`, `fahrzeug_ps`, `fahrzeug_kw`, `fahrzeug_leistung_bei_umdrehungen`, `fahrzeug_hubraum`, `fahrzeug_co2_emissions_wert`, `fahrzeug_leergewicht`, `fahrzeug_max_kmh`, `fahrzeug_sitzanzahl`, `fahrzeug_tueranzahl`, `fahrzeug_prod_monat_von`, `fahrzeug_prod_monat_bis`, `fahrzeug_prod_jahr_von`, `fahrzeug_prod_jahr_bis`, `fahrzeug_hsn`, `fahrzeug_tsn`, `fahrzeug_vsn`) VALUES
(1, 1, 'Audi', 1, 'RS4', 1, 'RS 4 Avant Quattro', 'B9', 'Kombi', 'e1*2001/116*0447*11', 'Allradantrieb', '1210', '1235', '2350', '4883', '1866', '1460', '80', '1900', '750', 'Benzin', 'Ottomotor', 'DECA', '7.6', NULL, NULL, NULL, NULL, NULL, NULL, '450', '331', '5700', '2894', '199', '1830', '280', '5', '5', '3', '11', '2018', '2019', '1860', 'AAS', '00001'),
(2, 1, 'Audi', 1, 'RS4', 2, 'RS 4 Avant Quattro', 'B9', 'Kombi', 'e1*2001/116*0447*15', 'Allradantrieb', '1225', '1235', '2350', '4883', '1866', '1449', '80', '1900', '750', 'Benzin', 'Ottomotor', 'DECA', '7.6', NULL, NULL, NULL, NULL, NULL, NULL, '450', '331', '5700', '2894', NULL, '1820', '290', '5', '5', '12', NULL, '2019', NULL, '1860', 'AAS', '00017'),
(3, 1, 'Audi', 1, 'RS4', 3, 'RS4 2.7 Avant Quattro', 'B5', 'Kombi', 'E1*98/14*0105*', 'Allradantrieb', '1145', '1140', '2170', '4525', '1799', '1350', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'ASJ, AZR', '6', '01E 6/1', '3.2', NULL, NULL, NULL, NULL, '381', '280', '6100', '2671', '287', '1695', '250', '5', '5', '2', '6', '2000', '2001', '7967', '307', '001'),
(4, 1, 'Audi', 1, 'RS4', 4, 'RS4 4.2 TFSI Quattro', 'QB6', 'Limousine', 'e1*2001/116*0243*04', 'Allradantrieb', '1230', '1100', '2200', '4589', '1816', '1450', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'BNS', '9.6', NULL, NULL, NULL, NULL, NULL, '12', '420', '309', '7800', '4163', '322', '1820', '280', '5', '4', '9', '8', '2005', '2008', '7967', 'AAE', '00001'),
(5, 1, 'Audi', 1, 'RS4', 5, 'RS4 Avant 4.2 FSI Quattro', 'B8', 'Kombi', 'e1*2001/116*0447*04', 'Allradantrieb', '1210', '1210', '2345', '4719', '1850', '1434', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'CFSA', '9.7', NULL, NULL, NULL, NULL, NULL, NULL, '450', '331', '8250', '4163', '249', '1870', '280', '5', '5', '4', '2', '2012', '2018', '7967', 'AAV', '00001'),
(6, 1, 'Audi', 1, 'RS4', 6, 'RS4 Avant 4.2 TFSI Quattro', 'QB6', 'Kombi', 'e1*2001/116*0243*04', 'Allradantrieb', '1230', '1150', '2260', '4589', '1816', '1475', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'BNS', '9.6', NULL, NULL, NULL, NULL, NULL, '12', '420', '309', '7800', '4163', '324', '1880', '280', '5', '5', '5', '8', '2006', '2008', '7967', 'AAA', '00001'),
(7, 1, 'Audi', 1, 'RS4', 7, 'RS4 Cabrio Quattro', 'QB6', 'Cabrio', 'e1*2001/116*0243*05', 'Allradantrieb', '1220', '1150', '2305', '4555', '1814', '1391', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'BNS', '9.6', NULL, NULL, NULL, NULL, NULL, '12', '420', '309', '7800', '4163', '334', '1920', '250', '4', '2', '5', '2', '2006', '2009', '7967', 'AAH', '00001'),
(8, 2, 'BMW', 2, 'Z8', 8, 'Z8 4.9 (E52)', 'Z52', 'Cabrio', 'e13*98/14*0054*', 'Heckantrieb', '920', '1070', '1930', '4400', '1830', '1317', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'S62', '7.5', NULL, NULL, NULL, NULL, NULL, '12.5', '400', '294', '6600', '4941', '349', '1690', '250', '2', '2', '3', '7', '2000', '2003', '0005', '674', '001'),
(9, 3, 'Mazda', 3, '929', 9, '929 2.0', 'HB', 'Limousine', 'C640*', 'Frontantrieb', '815', '925', '1740', '4680', '1690', '1355', NULL, '1000', '600', 'Benzin', 'Ottomotor', 'FE', '3.9', NULL, NULL, NULL, NULL, NULL, '7.5', '101', '74', '5600', '1984', NULL, '1200', '180', '5', '4', NULL, NULL, '1982', '1987', '7118', '311', '002'),
(10, 3, 'Mazda', 3, '929', 10, '929 2.0', 'HB', 'Limousine', 'C640*', 'Frontantrieb', '815', '925', '1740', '4705', '1690', '1420', NULL, '1100', '600', 'Benzin', 'Ottomotor', 'FE', NULL, NULL, NULL, NULL, NULL, NULL, NULL, '120', '88', '5300', '1984', NULL, '1170', '183', '5', '4', NULL, NULL, '1982', '1987', '7118', '321', '001'),
(11, 3, 'Mazda', 3, '929', 11, '929 2.0', 'HC', 'Limousine', 'E611*', 'Frontantrieb', '900', '1040', '1940', '4885', '1705', '1425', NULL, '1200', '700', 'Benzin', 'Ottomotor', 'FE', '4.2', NULL, NULL, NULL, NULL, NULL, '7.5', '116', '85', '5300', '1984', NULL, '1335', '182', '5', '4', NULL, NULL, '1987', '1992', '7118', '346', '001'),
(12, 3, 'Mazda', 3, '929', 12, '929 2.2', 'HC', 'Limousine', 'E611*', 'Frontantrieb', '900', '1040', '1940', '4885', '1705', '1425', NULL, '1200', '700', 'Benzin', 'Ottomotor', 'F2', '4.2', NULL, NULL, NULL, NULL, NULL, '7.5', '116', '85', '5000', '2169', NULL, '1340', '180', '5', '4', NULL, NULL, '1987', '1992', '7118', '374', '001'),
(13, 3, 'Mazda', 3, '929', 13, '929 2.2i', 'HC', 'Limousine', 'E611*', 'Frontantrieb', '900', '1040', '1940', '4885', '1705', '1425', NULL, '1200', '700', 'Benzin', 'Ottomotor', 'F2', '4.2', NULL, NULL, NULL, NULL, NULL, '7.5', '136', '100', '5500', '2169', NULL, '1380', '187', '5', '4', NULL, NULL, '1987', '1992', '7118', '347', '001'),
(14, 3, 'Mazda', 3, '929', 14, '929 3.0 V6', 'HC', 'Limousine', 'E611*', 'Frontantrieb', '980', '1060', '2040', '4885', '1705', '1425', NULL, '1500', '700', 'Benzin', 'Ottomotor', 'JE', '4.8', NULL, NULL, NULL, NULL, NULL, '9.4', '170', '125', '5300', '2918', NULL, '1495', '205', '5', '4', NULL, NULL, '1987', '1992', '7118', '375', '001'),
(15, 3, 'Mazda', 3, '929', 15, '929 3.0 V6', 'HC', 'Limousine', 'E611*', 'Frontantrieb', '980', '1060', '2040', '4885', '1705', '1425', NULL, '1500', '700', 'Benzin', 'Ottomotor', 'JE', '4.8', NULL, NULL, NULL, NULL, NULL, '9.4', '190', '140', '5500', '2918', NULL, '1460', '220', '5', '4', NULL, NULL, '1987', '1992', '7118', '348', '001'),
(16, 4, 'Mercedes', 4, 'SLS', 16, 'SLS AMG', '197', 'Coupe', 'e1*2007/46*0233*00', 'Heckantrieb', '920', '1125', '1935', '4646', '1985', '1264', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Mercedes-Benz M159.980', '9.5', NULL, NULL, '700.400 7/1', '7.8', NULL, '14', '571', '420', '6800', '6208', '308', '1695', '317', '2', '2', NULL, NULL, '2010', '2014', '1414', 'AAA', '00001'),
(17, 4, 'Mercedes', 4, 'SLS', 17, 'SLS AMG', '197', 'Cabrio', 'e1*2007/46*0233*01', 'Heckantrieb', '920', '1125', '1960', '4638', '1939', '1261', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Mercedes-Benz M159.980', '9.5', NULL, NULL, '700.400 7/1', '7.8', NULL, '14', '571', '420', '6800', '6208', '308', '1735', '317', '2', '5', '11', '1', '2011', '2014', '1414', 'AAB', '00001'),
(18, 4, 'Mercedes', 4, 'SLS', 18, 'SLS AMG Black Series', '197', 'Coupe', 'e1*2007/46*0233*04', 'Heckantrieb', '890', '1085', '1860', '4646', '1985', '1264', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Mercedes-Benz M159.980', '9.5', NULL, NULL, '700.400 7/1', '7.8', NULL, '14', '631', '464', '7400', '6208', '321', '1625', '315', '2', '2', '3', NULL, '2013', '2014', '1414', 'AAE', '00001'),
(19, 4, 'Mercedes', 4, 'SLS', 19, 'SLS AMG GT', '197', 'Coupe', 'e1*2007/46*0233*03', 'Heckantrieb', '920', '1125', '1935', '4646', '1985', '1264', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Mercedes-Benz M159.980', '9.5', NULL, NULL, '700.400 7/1', '7.8', NULL, '14', '592', '435', '6800', '6208', '308', '1695', '320', '2', '2', '7', NULL, '2012', '2014', '1414', 'AAC', '00001'),
(20, 4, 'Mercedes', 4, 'SLS', 20, 'SLS AMG GT', '197', 'Cabrio', 'e1*2007/46*0233*03', 'Heckantrieb', '920', '1125', '1960', '4638', '1939', '1261', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Mercedes-Benz M159.980', '9.5', NULL, NULL, '700.400 7/1', '7.8', NULL, '14', '592', '435', '6800', '6208', '308', '1735', '320', '2', '5', '11', '4', '2011', '2014', '1414', 'AAD', '00001'),
(21, 5, 'Opel', 5, 'Speedster', 21, 'Speedster 2.2 16V ecoFLEX', 'E00TARGA', 'Cabrio', 'e4*98/14*0056*', 'Frontantrieb', '450', '700', '1150', '3786', '1708', '1117', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Z22SE', '5.5', 'F18 5/1', '1.8', NULL, NULL, NULL, '12.3', '147', '108', '5800', '2198', '205', '945', '217', '2', '2', '3', '9', '2001', '2004', '0035', '419', '001'),
(22, 5, 'Opel', 5, 'Speedster', 22, 'Speedster Turbo', 'E00TARGA', 'Cabrio', 'e4*98/14*0056*', 'Frontantrieb', '470', '760', '1150', '3786', '1739', '1117', NULL, NULL, NULL, 'Benzin', 'Ottomotor', 'Z20LET', '4.5', '5/1', '1.75', NULL, NULL, NULL, '13.2', '200', '147', '5500', '1998', '202', '1005', '243', '2', '2', '9', '7', '2003', '2005', '0035', '493', '001'),
(23, 6, 'Porsche', 6, '928', 23, '928 4.5', '928', 'Coupe', 'A333*', 'Heckantrieb', '900', '1100', '1870', '4447', '1836', '1313', NULL, NULL, NULL, 'Benzin', 'Ottomotor', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '241', '177', '5500', '4420', NULL, '1520', '240', '4', '2', NULL, NULL, '1977', '1994', '0583', '378', '001'),
(24, 7, 'VW', 7, 'Fox', 24, 'Fox 1.2', '5Z', 'Schrägheck', 'e1*2001/116*0301*01', 'Frontantrieb', '765', '750', '1480', '3828', '1660', '1544', '50', '700', '520', 'Benzin', 'Ottomotor', 'BMD', '3', '02T 5/1', '2', NULL, NULL, NULL, '5.6', '54', '40', '4750', '1198', '144', '1165', '148', '4', '3', '4', NULL, '2005', '2011', '0603', 'AAT', '00001'),
(25, 7, 'VW', 7, 'Fox', 25, 'Fox 1.2', '5Z', 'Schrägheck', 'e1*2001/116*0301*10', 'Frontantrieb', '765', '750', '1480', '3828', '1660', '1524', '50', '700', '520', 'Benzin', 'Ottomotor', 'CHFA', '3', '02T 5/1', '2', NULL, NULL, NULL, '5.6', '60', '44', '5200', '1198', '136', '1069', '153', '4', '3', '10', NULL, '2010', '2011', '0603', 'AZB', '00001');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `hersteller`
--

DROP TABLE IF EXISTS `hersteller`;
CREATE TABLE `hersteller` (
  `id` int(11) NOT NULL,
  `hersteller_id` int(11) DEFAULT NULL,
  `hersteller_name` varchar(128) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `hersteller`
--

INSERT INTO `hersteller` (`id`, `hersteller_id`, `hersteller_name`) VALUES
(1, 1, 'Audi'),
(2, 2, 'BMW'),
(3, 3, 'Mazda'),
(4, 4, 'Mercedes'),
(5, 5, 'Opel'),
(6, 6, 'Porsche'),
(7, 7, 'VW');

-- --------------------------------------------------------

--
-- Tabellenstruktur für Tabelle `modelle`
--

DROP TABLE IF EXISTS `modelle`;
CREATE TABLE `modelle` (
  `id` int(11) NOT NULL,
  `hersteller_id` int(11) DEFAULT NULL,
  `hersteller_name` varchar(128) DEFAULT NULL,
  `modell_id` int(11) DEFAULT NULL,
  `modell_name` varchar(128) DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Daten für Tabelle `modelle`
--

INSERT INTO `modelle` (`id`, `hersteller_id`, `hersteller_name`, `modell_id`, `modell_name`) VALUES
(1, 1, 'Audi', 1, 'RS4'),
(2, 2, 'BMW', 2, 'Z8'),
(3, 3, 'Mazda', 3, '929'),
(4, 4, 'Mercedes', 4, 'SLS'),
(5, 5, 'Opel', 5, 'Speedster'),
(6, 6, 'Porsche', 6, '928'),
(7, 7, 'VW', 7, 'Fox');

--
-- Indizes der exportierten Tabellen
--

--
-- Indizes für die Tabelle `fahrzeuge`
--
ALTER TABLE `fahrzeuge`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `hersteller`
--
ALTER TABLE `hersteller`
  ADD PRIMARY KEY (`id`);

--
-- Indizes für die Tabelle `modelle`
--
ALTER TABLE `modelle`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT für exportierte Tabellen
--

--
-- AUTO_INCREMENT für Tabelle `fahrzeuge`
--
ALTER TABLE `fahrzeuge`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=26;

--
-- AUTO_INCREMENT für Tabelle `hersteller`
--
ALTER TABLE `hersteller`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;

--
-- AUTO_INCREMENT für Tabelle `modelle`
--
ALTER TABLE `modelle`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT, AUTO_INCREMENT=8;
COMMIT;

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
